#!/opt/puppetlabs/installer/bin/ruby
require 'hocon'
require 'hocon/config_syntax'

conf_file_path = ARGV[0]
begin
  conf = Hocon.load(conf_file_path,{:syntax => Hocon::ConfigSyntax::HOCON})
rescue Hocon::ConfigError::ConfigParseError => e
  puts %Q{\nERROR: Your pe.conf at #{conf_file_path} contains invalid HOCON syntax: #{e}\n\n}
  exit 1
end

if conf['console_admin_password'] && conf['console_admin_password'].empty?
  puts %Q{\nERROR: Specify a console_admin_password in your pe.conf file at #{conf_file_path}.\n\n}
  exit 1
end
