# frozen_string_literal: true

require 'logging'

module PeInstaller
  # Mixin for logging functions.
  module Logger
    attr_writer :logger

    def logger
      @logger ||= Logging.logger[self]
    end

    def log(level:, message:)
      logger.send(level, message)
    end

    def error(message)
      log(level: :err, message: message)
    end

    def warn(message)
      log(level: :warn, message: message)
    end

    def notice(message)
      log(level: :notice, message: message)
    end

    def info(message)
      log(level: :info, message: message)
    end

    def debug(message)
      log(level: :debug, message: message)
    end
  end
end
