# Reference

<!-- DO NOT EDIT: This document was generated by Puppet Strings -->

## Table of Contents

### Resource types

* [`ssh_authorized_key`](#ssh_authorized_key): Manages SSH authorized keys. Currently only type 2 keys are supported.
* [`sshkey`](#sshkey): Installs and manages ssh host keys.

## Resource types

### <a name="ssh_authorized_key"></a>`ssh_authorized_key`

In their native habitat, SSH keys usually appear as a single long line, in
the format `<TYPE> <KEY> <NAME/COMMENT>`. This resource type requires you
to split that line into several attributes.

To ensure that only the currently approved keys are present, you can purge
unmanaged SSH keys on a per-user basis.

This will remove any keys in `~/.ssh/authorized_keys` that aren't being
managed with `ssh_authorized_key` resources. See the documentation of the
`user` type for more details.

**Autorequires:** If Puppet is managing the user account in which this
SSH key should be installed, the `ssh_authorized_key` resource will autorequire
that user.

#### Examples

##### Thus, a key that appears in your `~/.ssh/id_rsa.pub` file like this...

```puppet

ssh-rsa AAAAB3Nza[...]qXfdaQ== nick@magpie.example.com
```

##### ...would translate to the following resource:

```puppet

ssh_authorized_key { 'nick@magpie.example.com':
  ensure => present,
  user   => 'nick',
  type   => 'ssh-rsa',
  key    => 'AAAAB3Nza[...]qXfdaQ==',
}
```

##### Do this with the `user` resource type's `purge_ssh_keys` attribute:

```puppet

user { 'nick':
  ensure         => present,
  purge_ssh_keys => true,
}
```

#### Properties

The following properties are available in the `ssh_authorized_key` type.

##### `ensure`

Valid values: `present`, `absent`

The basic property that the resource should be in.

Default value: `present`

##### `key`

The public key itself; generally a long string of hex characters. The `key`
attribute may not contain whitespace.

Make sure to omit the following in this attribute (and specify them in
other attributes):

* Key headers, such as 'ssh-rsa' --- put these in the `type` attribute.
* Key identifiers / comments, such as 'joe@joescomputer.local' --- put these in
  the `name` attribute/resource title.

##### `options`

Key options; see sshd(8) for possible values. Multiple values
should be specified as an array. For example, you could use the
following to install a SSH CA that allows someone with the
'superuser' principal to log in as root

     ssh_authorized_key { 'Company SSH CA':
       ensure  => present,
       user    => 'root',
       type    => 'ssh-ed25519',
       key     => 'AAAAC3NzaC[...]CeA5kG',
       options => [ 'cert-authority', 'principals=\"superuser\"' ],
     }

##### `target`

The absolute filename in which to store the SSH key. This
property is optional and should be used only in cases where keys
are stored in a non-standard location, for instance when not in
`~user/.ssh/authorized_keys`. The parent directory must be present
if the target is in a privileged path.

Default value: `absent`

##### `type`

Valid values: `ssh-dss`, `ssh-rsa`, `ecdsa-sha2-nistp256`, `ecdsa-sha2-nistp384`, `ecdsa-sha2-nistp521`, `ssh-ed25519`, `sk-ecdsa-sha2-nistp256@openssh.com`, `sk-ssh-ed25519@openssh.com`, `ssh-rsa-cert-v01@openssh.com`, `ssh-ed25519-cert-v01@openssh.com`, `ssh-dss-cert-v01@openssh.com`, `ecdsa-sha2-nistp256-cert-v01@openssh.com`, `ecdsa-sha2-nistp384-cert-v01@openssh.com`, `ecdsa-sha2-nistp521-cert-v01@openssh.com`, `dsa`, `ed25519`, `rsa`, `ecdsa-sk`, `ed25519-sk`

Aliases: `"dsa"=>"ssh-dss", "ed25519"=>"ssh-ed25519", "rsa"=>"ssh-rsa", "ecdsa-sk"=>"sk-ecdsa-sha2-nistp256@openssh.com", "ed25519-sk"=>"sk-ssh-ed25519@openssh.com"`

The encryption type used.

##### `user`

The user account in which the SSH key should be installed. The resource
will autorequire this user if it is being managed as a `user` resource.

#### Parameters

The following parameters are available in the `ssh_authorized_key` type.

* [`drop_privileges`](#-ssh_authorized_key--drop_privileges)
* [`name`](#-ssh_authorized_key--name)
* [`provider`](#-ssh_authorized_key--provider)

##### <a name="-ssh_authorized_key--drop_privileges"></a>`drop_privileges`

Valid values: `true`, `false`, `yes`, `no`

Whether to drop privileges when writing the key file. This is
useful for creating files in paths not writable by the target user. Note
the possible security implications of managing file ownership and
permissions as a privileged user.

Default value: `true`

##### <a name="-ssh_authorized_key--name"></a>`name`

namevar

The SSH key comment. This can be anything, and doesn't need to match
the original comment from the `.pub` file.

Due to internal limitations, this must be unique across all user accounts;
if you want to specify one key for multiple users, you must use a different
comment for each instance.

##### <a name="-ssh_authorized_key--provider"></a>`provider`

The specific backend to use for this `ssh_authorized_key` resource. You will seldom need to specify this --- Puppet will
usually discover the appropriate provider for your platform.

### <a name="sshkey"></a>`sshkey`

By default, this type will install keys into `/etc/ssh/ssh_known_hosts`.
To manage ssh keys in a different `known_hosts` file, such as a user's personal
`known_hosts`, pass its path to the `target` parameter. See the
`ssh_authorized_key` type to manage authorized keys.

#### Properties

The following properties are available in the `sshkey` type.

##### `ensure`

Valid values: `present`, `absent`

The basic property that the resource should be in.

Default value: `present`

##### `host_aliases`

Any aliases the host might have.  Multiple values must be
specified as an array.

##### `key`

The key itself; generally a long string of unencoded characters. The `key`
attribute may not contain leading or trailing whitespace.

Make sure to omit the following in this attribute (and specify them in
other attributes):

* Key headers, such as 'ssh-rsa' --- put these in the `type` attribute.

##### `target`

The file in which to store the ssh key.  Only used by
the `parsed` provider.

#### Parameters

The following parameters are available in the `sshkey` type.

* [`name`](#-sshkey--name)
* [`provider`](#-sshkey--provider)
* [`type`](#-sshkey--type)

##### <a name="-sshkey--name"></a>`name`

namevar

The host name that the key is associated with.

##### <a name="-sshkey--provider"></a>`provider`

The specific backend to use for this `sshkey` resource. You will seldom need to specify this --- Puppet will usually
discover the appropriate provider for your platform.

##### <a name="-sshkey--type"></a>`type`

Valid values: `ssh-dss`, `ssh-ed25519`, `ssh-rsa`, `ecdsa-sha2-nistp256`, `ecdsa-sha2-nistp384`, `ecdsa-sha2-nistp521`, `sk-ecdsa-sha2-nistp256@openssh.com`, `sk-ssh-ed25519@openssh.com`, `dsa`, `ed25519`, `rsa`, `ecdsa-sk`, `ed25519-sk`

namevar

Aliases: `"dsa"=>"ssh-dss", "ed25519"=>"ssh-ed25519", "rsa"=>"ssh-rsa", "ecdsa-sk"=>"sk-ecdsa-sha2-nistp256@openssh.com", "ed25519-sk"=>"sk-ssh-ed25519@openssh.com"`

The encryption type used.  Probably ssh-dss or ssh-rsa.

