# Ensures that the full facter facts are loaded into the given targets.
# Used as an alternative to apply_prep to bypass the potential side-effect
# of installing a random puppet-agent since PE nodes should have agents matching
# versions available from the primary. Consequently can only be run after
# the agent is installed.
function enterprise_tasks::get_facts_on(
  TargetSpec $nodes,
) {
  $targets = get_targets($nodes)
  $targets.each |$n| { enterprise_tasks::set_feature($n, 'puppet-agent', true) }
  run_plan('facts', 'targets' => $targets)
}
