# Given a PE family value (2019.3, 2018.1, main, ...), curl artifactory to
# find the latest available ci-ready PE dev build in that line, and return
# the full PE version (2019.3.0-rc2-11-gabc123). The later can then be used to
# download the tarball, or for version comparisons when pe_family is just 'main'...
#
# If given a full PE version, or nil, returns the given value unchanged.
function enterprise_tasks::lookup_pe_version(
  Optional[Enterprise_tasks::Pe_version_or_family] $pe_version_or_family,
) {
  case $pe_version_or_family {
    Enterprise_tasks::Pe_family: {
      $ci_ready_url = "https://artifactory.delivery.puppetlabs.net/artifactory/generic_enterprise__local/${pe_version_or_family}/ci-ready"
      $curl_of_latest_result = run_command("curl --fail --silent ${ci_ready_url}/LATEST", 'localhost')[0]
      $_pe_version = strip($curl_of_latest_result['stdout'])
    }
    default: {
      $_pe_version = $pe_version_or_family
    }
  }

  return $_pe_version
}
