# Validates that all the given targets match the expected platform_tag.
#
# Assumes that the targets have already had their facts looked up.
#
# @param targets
#   Array of Target instances to check.
# @parm expected_platform_tag
#   The platform_tag value that all the targets must match.
# @return
#   Returns an array of errors. If the array is empty, then the
#   targets are valid for the given platform.
#   Each error is a tuple of an error key and an error message.
function enterprise_tasks::validate_platform(
  Array[Target] $targets,
  String $expected_platform_tag,
) >> Array[Tuple[String,String]] {
  $mismatched = $targets.reduce({}) |$memo, $target| {
    $tag = enterprise_tasks::platform_tag($target.facts['os'])

    if $tag != $expected_platform_tag {
      $tag_targets = ($memo[$tag] =~ Undef) ? {
        true    => [$target],
        default => $memo[$tag] + [$target],
      }
      $memo + { $tag => $tag_targets }
    } else {
      $memo
    }
  }

  $multiple_platforms_err = ($mismatched.empty()) ? {
    true    => [],
    default => [['platform-check-error', "Expected all targets to be '${expected_platform_tag}'. Found ${mismatched}"]]
  }

  return $multiple_platforms_err
}
