require 'securerandom'

# Generate a random password of the given length using Ruby's SecureRandom library.
# This chooses characters from each of the four groups (upper, lower, numbers, special)
# in order to attempt to create a password that can meet whatever complexity requirements
# the user has set in PE. This isn't guaranteed to do so if they have exotic requirements,
# but with a sufficiently long length, should take care of most cases.
#
# @param length [Integer] number of characters to generate.
# @return [String] password.
Puppet::Functions.create_function('enterprise_tasks::generate_random_password') do
  dispatch :generate_random_password do
    param 'Integer', :length
    return_type 'String'
  end

  def generate_random_password(length)
    charsets = [
      [*'A'..'Z'],
      [*'a'..'z'],
      [*'0'..'9'],
      # Technically can be anything that matches \p{punct}, but just choosing a convenient subset here
      ['!', '@', '#', '$', '*', '+', '-', '_', '/', ':', ';', '=', '>', '<', '?', '^', '~', '.'],
    ]
    result = []
    Array.new(length) do |i|
      chars = charsets[i % 4]
      result << chars[SecureRandom.random_number(chars.length)]
    end
    result.shuffle.join
  end
end
