# Creates a local code repo at the given path on the primary
# with an empty production branch commit.
#
# Installs git on the node.
#
# Useful for testing if you don't want to use a real control repo.
plan enterprise_tasks::testing::generate_empty_code_repository(
  Variant[Target,String] $primary,
  Enterprise_tasks::Absolute_path $control_repo_path = constants()['default_control_repo_path'],
) {
  $primary_target = get_targets($primary)[0]

  $manifests_dir = "${control_repo_path}/manifests"
  $site_pp = "${manifests_dir}/site.pp"

  apply($primary_target) {
    $file_opts = {
      mode   => '0600',
      owner  => 'pe-puppet',
      group  => 'pe-puppet',
    }
    file { [$control_repo_path, $manifests_dir]:
      ensure => directory,
      *      => $file_opts,
    }
    file { $site_pp:
      ensure  => file,
      content => "# empty\n",
      *       => $file_opts,
    }

    package { 'git':
      ensure => present,
    }

    $init_commands = [
      'git init .',
      'git add manifests/',
      "git config user.email 'root@${primary_target.host}'",
      "git commit -m 'Initial Commit'",
      'git checkout -b production',
    ]
    exec { "init repo at ${control_repo_path}":
      command => join($init_commands, ' && '),
      path    => '/usr/bin:/bin:/sbin:/usr/sbin',
      unless  => 'git status',
      cwd     => $control_repo_path,
      require => [Package['git'], File[$site_pp]],
    }
  }
}
