# Tests to be performed before installation.
#
# * Can we connect to each node?
# * Do all the nodes have the same platform?
# * Does the platform match the given tarball's platform?
#
plan enterprise_tasks::testing::pre_check(
  TargetSpec $targets,
  String $tarball_platform,
) {
  $_targets = get_targets($targets)

  enterprise_tasks::message('pre_check', 'Checking connectivity to to all targets.')
  enterprise_tasks::test_connection($_targets)

  enterprise_tasks::message('pre_check', 'Checking platform.')
  run_plan('facts', 'targets' => $_targets)

  $platform_errors = enterprise_tasks::validate_platform($_targets, $tarball_platform)

  if !$platform_errors.empty() {
    fail_plan(
      'Failed platform validation.',
      'pe.pre_check/platform-validation-err',
      {
        'errors' => $platform_errors,
      }
    )
  }

  $result = {
    'errors' => [],
  }
  return $result
}
