#!/opt/puppetlabs/puppet/bin/ruby

require 'hocon/parser/config_document_factory'
require 'hocon/config_value_factory'
require 'json'

require_relative '../files/enterprise_task_helper.rb'

class AddModifyConfKeys < EnterpriseTaskHelper
  def task(file:, hash:, quote: true, **_kwargs)
    result = {}
    if file.nil? || file.empty? || hash.nil? || hash.empty?
      raise EnterpriseTaskHelper::Error.new('file and hash arguments must have values', 'puppetlabs.add_modify_conf_keys/invalid_value', nil)
    end
    if !File.exist?(file)
      raise EnterpriseTaskHelper::Error.new("File not found: #{file}", 'puppetlabs.add_modify_conf_keys/file_not_found', 'conf_file' => file)
    end
    conf = Hocon::Parser::ConfigDocumentFactory.parse_file(file)
    hash.each do |k, v|
      if quote
        key = "\"#{k}\""
        value = if v.is_a?(String)
                  "\"#{v}\""
                else
                  v.to_json
                end
        conf = conf.set_value(key, value)
      else
        conf = conf.set_value(k.to_s, v.to_json)
      end
    end
    File.open(file, 'w') { |f| f << conf.render }
    result[:status] = :success
    result.to_json
  end
end

AddModifyConfKeys.run if __FILE__ == $PROGRAM_NAME
