#!/opt/puppetlabs/puppet/bin/ruby
# frozen_string_literal: true

require_relative '../files/enterprise_task_helper.rb'
require 'json'
require 'open3'
require 'puppet'

class DeleteCAFiles < EnterpriseTaskHelper
  def task(_)
    certname = Open3.capture2e('/opt/puppetlabs/bin/puppet config print certname')[0].strip
    output, status = Open3.capture2e('rm -rf /etc/puppetlabs/puppet/ssl/*')
    raise EnterpriseTaskHelper::Error.new("Unable to remove CA files on host with certname #{certname}", 'puppetlabs.delete-ca-files/remove-ssl-dir-contents-failed', 'output' => output) if !status.exitstatus.zero?

    output, status = Open3.capture2e('rm -rf /etc/puppetlabs/puppetserver/ca/*')
    raise EnterpriseTaskHelper::Error.new("Unable to remove CA files on host with certname #{certname}", 'puppetlabs.delete-ca-files/remove-ca-dir-contents-failed', output) if !status.exitstatus.zero?

    cmd = ['rm', '-f', "/opt/puppetlabs/puppet/cache/client_data/catalog/#{certname}.json"]
    output, status = Open3.capture2e(*cmd)
    raise EnterpriseTaskHelper::Error.new("Unable to remove cached catalog on host with certname #{certname}", 'puppetlabs.delete-ca-files/remove-cached-catalog-failed', 'output' => output) if status.exitstatus != 0

    result = { _output: output }
    result.to_json
  end
end

DeleteCAFiles.run if __FILE__ == $PROGRAM_NAME
