#!/opt/puppetlabs/puppet/bin/ruby
# frozen_string_literal: true

require_relative '../files/enterprise_task_helper.rb'
require_relative '../lib/enterprise_tasks/puppet_helper.rb'
require 'open3'

class GetPuppetConfigSetting < EnterpriseTaskHelper
  include EnterpriseTasks::PuppetHelper

  def task(setting:, section: 'main', **_kwargs)
    cmd = [puppet_bin, 'config', 'print', setting, '--section', section]
    result, status = Open3.capture2e(*cmd)
    raise EnterpriseTaskHelper::Error.new("Error running #{cmd.join(' ')}", 'puppetlabs.get-puppet-config-setting', 'output' => result) if !status.exitstatus.zero?
    result = { value: result.chomp }
    result.to_json
  end
end

GetPuppetConfigSetting.run if __FILE__ == $PROGRAM_NAME
