# Return the first element of the array that is not Undef or an empty string.
function enterprise_tasks::first_defined(
  Array *$args,
) {
  $defined = $args.filter |$i| {
    # The empty() function can't handle the Bolt Target type.
    ($i !~ Undef) and ($i != '')
  }[0]

  if $defined =~ Undef {
    fail("The first_defined function was unable to find a defined element of '${args}'.")
  }

  return $defined
}
