#!/opt/puppetlabs/puppet/bin/ruby
# frozen_string_literal: true

require 'json'

require_relative '../lib/enterprise_tasks/network'
require_relative '../files/enterprise_task_helper.rb'

class HttpHelper
  include EnterpriseTasks::Network
end

class FileSyncCommit < EnterpriseTaskHelper

  def task(filesync_host:, environment_names:, **_kwargs)
    body = {
      message: 'Commit to trigger lockless deploys of previously deployed environments',
      author: {
        name: 'enable_lockless_deploys Plan',
        email: '',
      },
      'repo-id': 'puppet-code',
      'submodule-ids': environment_names,
    }

    http = HttpHelper.new
    response = http.request(filesync_host, 8140, 'file-sync/v1/commit', method: :post, body: body)
    commit = JSON.parse(response.body)['puppet-code']

    {
      success: true,
      commit: commit,
    }
  end
end

FileSyncCommit.run if __FILE__ == $PROGRAM_NAME
