# defined type for configuration of license checks for services that perform
# checks of the PE license for entitlements
#
# @param conf_file_path [String] File path to the configuration file where
# @param license_api [String] URL where services can check the PE license
# @param check_interval [Integer] Number of seconds between checking the
#                                 license for changes/updates
# @param retries [Integer] Number of times to retry fetching license data if
#                          the URL fails to return data.
define puppet_enterprise::license_check_config (
  String $conf_file_path,
  String $license_api,
  Integer $check_interval,
  Integer $retries
) {
  Pe_hocon_setting {
    ensure      => present,
    path        => $conf_file_path,
    require     => File[$conf_file_path],
  }

  pe_hocon_setting { "${conf_file_path}.license-check.license-api":
    path    => $conf_file_path,
    setting => 'license-check.license-api',
    value   => $license_api,
  }

  pe_hocon_setting { "${conf_file_path}.license-check.check-interval-seconds":
    path    => $conf_file_path,
    setting => 'license-check.check-interval-seconds',
    value   => $check_interval,
  }

  pe_hocon_setting { "${conf_file_path}.license-check.retries":
    path    => $conf_file_path,
    setting => 'license-check.retries',
    value   => $retries,
  }
}
