#!/usr/bin/env ruby
# frozen_string_literal: true

# Discard uncommitted changes in the candidate datastore
# This is useful for clearing session ID 0 locks on Arista devices

require_relative '../../edgeops/files/task_helper.rb'
require 'puppet_x/puppetlabs/netconf/session'

result = PuppetX::Puppetlabs::Netconf::Session.with_session do |session|
  if session.supports_candidate?
    session.discard_changes
    session.report_result({
                            'message' => 'Successfully discarded candidate changes',
      'candidate_supported' => true
                          })
  else
    session.report_result({
                            'message' => 'Device does not support candidate datastore',
      'candidate_supported' => false
                          })
  end
end

puts result.to_json
