# playbook_runner
A Puppet module for executing YAML-based automation playbooks

## Table of Contents

1. [Prerequisites](#prerequisites)
1. [Quickstart](#quickstart)
1. [Output](#output)
1. [Example Ansible Inventory](#example-ansible-inventory)
1. [Example Ansible Playbook](#example-ansible-playbook)
1. [Troubleshooting](#troubleshooting)

## Prerequisites
1. Ansible Control Node Installed
1. Ansible Inventory File on Control Node that includes ssh connectivity details
1. Puppet Agent or Ruby installed on Control Node
1. Puppet Bolt or PE Instance

## Quickstart

#### Installation
```
mkdir my_ansible_project
cd my_ansible_project
bolt project init my_ansible_project
```
Update bolt-project.yaml to reference the playbook_runner module
```
name: my_ansible_project
modules:
  - name: puppetlabs-playbook_runner
```
Installing module deps
```
bolt module install
```
Update inventory file to point to your Ansible Control Node.
Note: ruby interpreter does not need defined when puppet agent installed.
```
---
targets:
  - name: ansible-control-node
    uri: ansible-control-node-fqdn
    config:
      transport: ssh
      ssh:
        user: <username>
        private-key: <path to SSH private key>
        run-as: root
        host-key-check: false
        native-ssh: true
        interpreters:
          .rb:
          - <full path to ruby interpreter>
```
#### Start executing ansible content on your ansible control node
```
bolt task run playbook_runner::playbook --targets ansible-control-node playbook=/etc/ansible/playbooks/create-users.yaml inventory=/etc/ansible/inventory/hosts
bolt task run playbook_runner::command --targets ansible-control-node module_name=ping inventory=inventory/hosts stdout_callback=yaml
```
#### Passing Extra Variables/Arguments
Due to parsing complexitiess around qoutes spaces etc, passing extra variables can be tricky.
See some bolt working examples below;
```
bolt task run playbook_runner::playbook --targets ansible-control-node-2 playbook=/etc/ansible/playbooks/echo-params.yaml inventory=/etc/ansible/inventory/hosts extra_vars='{"alb_name":"puppet-demo-alb","vpc_subnets":["prod-main-vpc-us-east-1a-public-alb","prod-main-vpc-us-east-1b-public -alb"]}' stdout_callback=yaml
bolt task run playbook_runner::playbook --targets ansible-control-node-2 playbook=/etc/ansible/playbooks/echo-params.yaml inventory=/etc/ansible/inventory/hosts extra_vars="{'alb_name': 'puppet-demo-alb','vpc_subnets': ['prod-main-vpc-us-east-1a-public-alb','prod-main-vpc-us-east-1b-public-alb']}" additional_arguments='-e region="some where"' stdout_callback=yaml
bolt task run playbook_runner::command --targets ansible-control-node-2 module_name=ping inventory=/etc/ansible/inventory/hosts stdout_callback=yaml additional_arguments='-vvvv'
```
#### When Running Tasks Within Puppet Enterprise UI
When configuring extra_vars in the UI, single quotes must be used. Parameter must not be wrapped in quotes.
E.g
```
{'alb_name': 'puppet-demo-alb','vpc_subnets':['prod-main-vpc-us-east-1a-public-alb','prod-main-vpc-us-east-1b-public -alb']}
```
When configuring additional_arguments in the UI, double quotes should be used to preserve spaces. Parameter must not be wrapped in quotes.
```
-e region="some where"
```

## Output
By default, Playbook Runner data is returned in a Puppet customized format. This provides short, readable, consistent output that can be parsed by Puppet workflows and plans.
However, an alternative format can be specified using the parameter stdout_callback. Using the YAML format can be helpful for debugging playbook failures but any ansible stdout_callback can be specified.
The module also ships with a further puppet based stdout_callback. Setting to puppet_minimal will reduce the output even further and will return a single pass fail result for each node in the ansible inventory. This is particularly useful when executing at scale.

## Example Ansible Inventory
```
[region1]
10.253.12.19

[region1:vars]
ansible_ssh_private_key_file=/etc/ansible/keys/my_key
ansible_user=joebloggs
```

## Example Ansible Playbook
```
- hosts: all
  become: yes
  tasks:
    - name: Add User1
      user:
        name: demo1
        shell: /bin/bash
        groups: sudo
    - name: Add User2
      user:
        name: demo2
        shell: /bin/bash
        groups: sudo
```

## Troubleshooting 
- To clearly see error details and the command being executed, ensure bolt run with format set to json.  Just append `--format json` to bolt the command.
- Main recommendation to troubleshoot issues is to take the command that is being executed by the module and ssh to your ansible control node and manually run it.
- E.g. ansible-playbook /etc/ansible/playbooks/create-users.yaml -i /etc/ansible/inventory/hosts
- Note that *ANSIBLE_CALLBACK_PLUGINS* and *ANSIBLE_STDOUT_CALLBACK* env vars should not be included when runing the command manually on the control node.





