from ansible.plugins.callback import CallbackBase
import json

class CallbackModule(CallbackBase):
    CALLBACK_VERSION = 2.0
    CALLBACK_TYPE = 'stdout'
    CALLBACK_NAME = 'puppet_minimal'
    CALLBACK_NEEDS_WHITELIST = True

    def __init__(self):
        super(CallbackModule, self).__init__()
        self._stats = None

    def v2_playbook_on_stats(self, stats):
        self._stats = stats
        summary_data = {}

        hosts = sorted(stats.processed.keys())
        for host in hosts:
            summary=stats.summarize(host)
            if summary['failures'] > 0 or summary['unreachable'] > 0:
                summary_data[host] = 'FAIL'
            else:
                summary_data[host] = 'PASS'

        # Output the summary as JSON
        print(json.dumps(summary_data, indent=2))
