# Reference
<!-- DO NOT EDIT: This document was generated by Puppet Strings -->

## Table of Contents

**Defined types**

* [`pe_concat`](#pe_concat): Manages a file, compiled from one or more text fragments.
* [`pe_concat::fragment`](#pe_concatfragment): Manages a fragment of text to be compiled into a file.

**Resource types**

* [`pe_concat_file`](#pe_concat_file): Generates a file with content from fragments sharing a common unique tag.
* [`pe_concat_fragment`](#pe_concat_fragment): Manages the fragment.

**Data types**

* [`Pe_concat::Absolutepath`](#pe_concatabsolutepath): Borrowed from Stdlib::Unixpath this regex rejects any path component that does not start with "/" or is NUL

## Defined types

### pe_concat

Manages a file, compiled from one or more text fragments.

#### Examples

##### 

```puppet
pe_concat { '/tmp/concat':
  ensure => present,
  owner  => 'root',
  group  => 'root',
  mode   => '0644',
}
```

#### Parameters

The following parameters are available in the `pe_concat` defined type.

##### `backup`

Data type: `Variant[Boolean, String]`

Specifies whether (and how) to back up the destination file before overwriting it. Your value gets passed on to Puppet's native file
resource for execution. Valid options: true, false, or a string representing either a target filebucket or a filename extension
beginning with ".".

Default value: 'puppet'

##### `ensure`

Data type: `Enum['present', 'absent']`

Specifies whether the destination file should exist. Setting to 'absent' tells Puppet to delete the destination file if it exists, and
negates the effect of any other parameters.

Default value: 'present'

##### `ensure_newline`

Data type: `Boolean`

Specifies whether to add a line break at the end of each fragment that doesn't already end in one.

Default value: `false`

##### `format`

Data type: `Optional[String]`

Specify what data type to merge the fragments as. Valid options: 'plain', 'yaml', 'json', 'json-array', 'json-pretty',
'json-array-pretty'.

Default value: 'plain'

##### `force`

Data type: `Optional[Boolean]`

Specifies whether to merge data structures, keeping the values with higher order. Used when format is specified as a value other than
'plain'.

Default value: `false`

##### `group`

Data type: `Optional[Variant[String, Integer]]`

Specifies a permissions group for the destination file. Valid options: a string containing a group name or integer containing a gid.

Default value: `undef`

##### `mode`

Data type: `String`

Specifies the permissions mode of the destination file. Valid options: a string containing a permission mode value in octal notation.

Default value: '0644'

##### `order`

Data type: `Enum['alpha','numeric']`

Specifies a method for sorting your fragments by name within the destination file. You can override this setting for individual
fragments by adjusting the order parameter in their pe_concat::fragment declarations.

Default value: 'alpha'

##### `owner`

Data type: `Optional[Variant[String, Integer]]`

Specifies the owner of the destination file. Valid options: a string containing a username or integer containing a uid.

Default value: `undef`

##### `path`

Data type: `Pe_concat::Absolutepath`

Specifies a destination file for the combined fragments.

Default value: $name

##### `replace`

Data type: `Boolean`

Specifies whether to overwrite the destination file if it already exists.

Default value: `true`

##### `selinux_ignore_defaults`

Data type: `Optional[Boolean]`

See the file type's selinux_ignore_defaults documentention:
https://docs.puppetlabs.com/references/latest/type.html#file-attribute-selinux_ignore_defaults

Default value: `undef`

##### `selrange`

Data type: `Optional[String]`

See the file type's selrange documentention: https://docs.puppetlabs.com/references/latest/type.html#file-attribute-selrange

Default value: `undef`

##### `selrole`

Data type: `Optional[String]`

See the file type's selrole documentention: https://docs.puppetlabs.com/references/latest/type.html#file-attribute-selrole

Default value: `undef`

##### `seltype`

Data type: `Optional[String]`

See the file type's seltype documentention: https://docs.puppetlabs.com/references/latest/type.html#file-attribute-seltype

Default value: `undef`

##### `seluser`

Data type: `Optional[String]`

See the file type's seluser documentention: https://docs.puppetlabs.com/references/latest/type.html#file-attribute-seluser

Default value: `undef`

##### `show_diff`

Data type: `Boolean`

Specifies whether to set the show_diff parameter for the file resource. Useful for hiding secrets stored in hiera from insecure
reporting methods.

Default value: `true`

##### `validate_cmd`

Data type: `Optional[String]`

Specifies a validation command to apply to the destination file.

Default value: `undef`

##### `warn`

Data type: `Variant[Boolean, String]`

Specifies whether to add a header message at the top of the destination file. Valid options: the booleans true and false, or a string
to serve as the header.
If you set 'warn' to true, pe_concat adds the following line with an order of 0:
`# This file is managed by Puppet. DO NOT EDIT.`
Before 2.0.0, this parameter would add a newline at the end of the warn message. To improve flexibilty, this was removed. Please add
it explicitly if you need it.

Default value: `false`

### pe_concat::fragment

Manages a fragment of text to be compiled into a file.

#### Parameters

The following parameters are available in the `pe_concat::fragment` defined type.

##### `content`

Data type: `Optional[String]`

Supplies the content of the fragment. Note: You must supply either a content parameter or a source parameter.

Default value: `undef`

##### `order`

Data type: `Variant[String, Integer]`

Reorders your fragments within the destination file. Fragments that share the same order number are ordered by name. The string
option is recommended.

Default value: '10'

##### `source`

Data type: `Optional[Variant[String, Array]]`

Specifies a file to read into the content of the fragment. Note: You must supply either a content parameter or a source parameter.
Valid options: a string or an array, containing one or more Puppet URLs.

Default value: `undef`

##### `target`

Data type: `String`

Specifies the destination file of the fragment. Valid options: a string containing the path or title of the parent pe_concat resource.

## Resource types

### pe_concat_file

Generates a file with content from fragments sharing a common unique tag.

#### Examples

##### 

```puppet
Pe_concat_fragment <<| tag == 'unique_tag' |>>

pe_concat_file { '/tmp/file':
  tag            => 'unique_tag', # Optional. Default to undef
  path           => '/tmp/file',  # Optional. If given it overrides the resource name
  owner          => 'root',       # Optional. Default to undef
  group          => 'root',       # Optional. Default to undef
  mode           => '0644'        # Optional. Default to undef
  order          => 'numeric'     # Optional, Default to 'numeric'
  ensure_newline => false         # Optional, Defaults to false
}
```

#### Properties

The following properties are available in the `pe_concat_file` type.

##### `ensure`

Valid values: present, absent

Specifies whether the destination file should exist. Setting to 'absent' tells Puppet to delete the destination file if it exists, and
negates the effect of any other parameters.

Default value: present

#### Parameters

The following parameters are available in the `pe_concat_file` type.

##### `tag`

Required. Specifies a unique tag reference to collect all pe_concat_fragments with the same tag.

##### `path`

Specifies a destination file for the combined fragments. Valid options: a string containing an absolute path. Default value: the
title of your declared resource.

##### `owner`

Specifies the owner of the destination file. Valid options: a string containing a username or integer containing a uid.

##### `group`

Specifies a permissions group for the destination file. Valid options: a string containing a group name or integer containing a
gid.

##### `mode`

Specifies the permissions mode of the destination file. Valid options: a string containing a permission mode value in octal notation.

##### `order`

Valid values: alpha, numeric

Specifies a method for sorting your fragments by name within the destination file. You can override this setting for individual
fragments by adjusting the order parameter in their pe_concat::fragment declarations.

Default value: numeric

##### `backup`

Specifies whether (and how) to back up the destination file before overwriting it. Your value gets passed on to Puppet's native file
resource for execution. Valid options: true, false, or a string representing either a target filebucket or a filename extension
beginning with ".".'

##### `replace`

Valid values: `true`, `false`, yes, no

Specifies whether to overwrite the destination file if it already exists.

Default value: `true`

##### `validate_cmd`

Specifies a validation command to apply to the destination file. Requires Puppet version 3.5 or newer. Valid options: a string to
be passed to a file resource.

##### `ensure_newline`

Valid values: `true`, `false`, yes, no

Specifies whether to add a line break at the end of each fragment that doesn't already end in one.

Default value: `false`

##### `format`

Valid values: plain, yaml, json, json-array, json-pretty, json-array-pretty

Specify what data type to merge the fragments as. Valid options: 'plain', 'yaml', 'json', 'json-array', 'json-pretty', 'json-array-pretty'.

Default value: plain

##### `force`

Valid values: `true`, `false`, yes, no

Specifies whether to merge data structures, keeping the values with higher order.

Default value: `false`

##### `selinux_ignore_defaults`

Valid values: `true`, `false`, yes, no

See the file type's selinux_ignore_defaults documentention:
https://docs.puppetlabs.com/references/latest/type.html#file-attribute-selinux_ignore_defaults.

##### `selrange`

See the file type's selrange documentation: https://docs.puppetlabs.com/references/latest/type.html#file-attribute-selrange

##### `selrole`

See the file type's selrole documentation: https://docs.puppetlabs.com/references/latest/type.html#file-attribute-selrole

##### `seltype`

See the file type's seltype documentation: https://docs.puppetlabs.com/references/latest/type.html#file-attribute-seltype

##### `seluser`

See the file type's seluser documentation: https://docs.puppetlabs.com/references/latest/type.html#file-attribute-seluser

##### `show_diff`

Valid values: `true`, `false`, yes, no

Specifies whether to set the show_diff parameter for the file resource. Useful for hiding secrets stored in hiera from insecure
reporting methods.

### pe_concat_fragment

Manages the fragment.

#### Examples

##### 

```puppet
# The example is based on exported resources.

pe_concat_fragment { \"uniqe_name_${::fqdn}\":
  tag => 'unique_name',
  order => 10, # Optional. Default to 10
  content => 'some content' # OR
  # content => template('template.erb')
  source  => 'puppet:///path/to/file'
}
```

#### Parameters

The following parameters are available in the `pe_concat_fragment` type.

##### `name`

namevar

Name of resource.

##### `target`

Required. Specifies the destination file of the fragment. Valid options: a string containing the path or title of the parent
pe_concat_file resource.

##### `content`

Supplies the content of the fragment. Note: You must supply either a content parameter or a source parameter. Valid options: a string

##### `source`

Specifies a file to read into the content of the fragment. Note: You must supply either a content parameter or a source parameter.
Valid options: a string or an array, containing one or more Puppet URLs.

##### `order`

Reorders your fragments within the destination file. Fragments that share the same order number are ordered by name. The string
option is recommended.

Default value: 10

##### `tag`

Specifies a unique tag to be used by pe_concat_file to reference and collect content.

## Data types

### Pe_concat::Absolutepath

Borrowed from Stdlib::Unixpath
this regex rejects any path component that does not start with "/" or is NUL

Alias of `Pattern[/\A\/([^\n\/\0]+\/*)*\z/]`

