#!/opt/puppetlabs/puppet/bin/ruby
# frozen_string_literal: true

require_relative '../lib/pe_install/pe_postgresql_info.rb'
require 'json'

PE_BUILD_LOCATION='/opt/puppetlabs/server/pe_build'
class GetPostgresInfo
  def self.run
    fact = PEPostgresqlInfo.new
    pe_postgresql_info = fact.to_hash
    pe_build_file = File.read(PE_BUILD_LOCATION)

    result = {
      pe_postgresql_info: pe_postgresql_info,
      pe_build_version: pe_build_file
    }
    STDOUT.print JSON.generate(result)
  end
end

GetPostgresInfo.run if __FILE__ == $PROGRAM_NAME
