# puppet infrastructure forget

## MAN PAGE

```
USAGE: puppet infrastructure forget [--force]
[--token-file <token_path>]
<replica_certname>

Purge replication slots previously dedicated to the given node
and remove it from the HA Replica node group.

DESCRIPTION:
Performs required cleanup if a replica goes offline permanently.

IMPORTANT: You must run this command after a replica goes permanently offline,
or the performance of Puppet Enterprise will degrade over time.
Forgetting a replica is required whenever a replica node is destroyed, even if
you plan to replace it with a replica with the same name. The command cleans up
classification and database state. If you fail to forget a destroyed replica,
agent runs take longer and the primary master's disk eventually fills with
pending replication statements.

REQUIREMENTS:
- Target node must be permanently offline.
This command must be invoked on the primary master.

OPTIONS:
  --token-file                      Specifies path to an RBAC token to use for
                                    authentication. Defaults to ~/.puppetlabs/token.
  --force                           Skip all pre-forget validation. Skipping checks
                                    will mean that prerequisite services may not be
                                    configured or running and some forget steps may
                                    fail or need to be manually run.
  --render-as <FORMAT>              The rendering format to use.
  --verbose                         Whether to log verbosely.
  --debug                           Whether to log debug information.
  --trace                           Displays stack traces.
  --help, -h                        Displays man page.
```

## Examples

```
> puppet infrastructure forget HOSTNAME

Ensure that the replication slots for this primary master replica are inactive. If you continue, the primary master replica will no longer be available for failover. Continue? [Y,n]
```

If n:

```
You can check whether the primary master replica’s replication slots are active by running `puppet infrastructure status`.
```

    If Y:
Output progress info related to:
  1) Removing replication slots
  2) Unpinning from replica group, etc
  3) Running puppet locally
When complete, say:

```
This node is no longer a primary master replica.

You can revoke the certificates for this node and deactivate it in PuppetDB, by entering puppet node purge <CERTNAME>.
```

Error1: Replication slots are still active

```
The replication slots for the primary master replica <insert HOSTNAME for specificity> are still active. The `puppet infrastructure forget replica` command can’t run for an active primary master replica.
```

Error2: While unpinning from replica group

```
An error occurred while changing classification. <output content if available>.

The `puppet infrastructure forget replica` action could not be completed. Contact Puppet Customer Support <not sure if we typically give contact info here>
```

Error3: While running puppet
```
An error occurred while running Puppet. <output content if available>.

The `puppet infrastructure forget replica` action could not be completed.
```
