# puppet infrastructure provision compiler

```
USAGE: puppet infrastructure provision [--token-file PATH] compiler <node_certname>

DESCRIPTION:
Provisions a new compiler (with puppetserver and puppetdb services).

REQUIREMENTS:
  - An agent node to provision the replica on, running the same platform as
    your primary master. It must not already be an infrastructure node.
  - A valid token that has permission to run the Puppet agent with
    orchestrator. You can generate a token with `puppet access login`.

OPTIONS:
  --token-file <PATH>               Specifies path to an RBAC token to use for
                                    authentication. Defaults to ~/.puppetlabs/token.
  --dns-alt-names                   Additional subject alt names to add to the
                                    compiler certificate.
  --force                           Whether or not to push past node and SAN
                                    verification tests. Defaults to false.
```

This action runs the `enterprise_tasks::provision_compiler` plan via the
Orchestrator by default. For details see the `enterprise_tasks` repository.

NOTE: This builds a compiler with both puppetserver and puppetdb services. For a
legacy compiler that does not include puppetdb service (useful where compiler
network latency is an issue) manual workflow is needed. Generating a legacy
compiler involves manually pinning the node in the PE node groups, but we don't
appear to be documenting the workflow in the current 2025 PE docs. Older PE
docs will have the workflow, and I believe support has instructions as well.
