require 'puppet/indirector/face'
require 'puppet_x/util/password'
require 'puppet_x/util/interview'

Puppet::Face.define(:infrastructure, '1.0.0') do

  action :console_password do
    summary _("Reset the console admin password")
    description(
      PuppetX::Util::String::Formatter.wrap_no_indent(
        _('Reset the console administrator password using the command line. ') +
        _('If --password is not given and --reset-url is not specified, prompts the user for the password.')))

    option('--password <PASSWORD>') do
      summary _("New console admin password")
      description "New console admin password"
    end

    option('--reset-url') do
      summary _("Display the console admin password reset URL")
      description "Display the console admin password reset URL"
    end

    when_invoked do |options|
      if `id -u`.chomp != "0"
        Puppet.err _("Please run this command as root")
        exit 1
      end

      if options[:reset_url]
        url = PuppetX::Util::PasswordUtils.console_reset_admin_url
        puts ("Use this link to reset the console admin password: #{url}")
      else
        password = options[:password]

        if password.nil? || password.empty?
          password = PuppetX::Util::Interview.ask_password(_("Please enter the new console admin password"))
          verify = PuppetX::Util::Interview.ask_password(_("Please confirm the new console admin password"))
          if password != verify
            Puppet.err _("Passwords do not match. Password not changed.")
            exit 1
          end
        end
        
        PuppetX::Util::PasswordUtils.reset_password('admin',password)
        puts _("Password successfully changed")
      end
    end
  end
end
