require 'puppet/indirector/face'

=begin
Puppet::Face.define(:infrastructure, '1.0.0') do
  action :uninstall do
    summary "Uninstalls Puppet Enterprise from the system"

    option '-y', '--yes' do
      summary "Assume yes to 'Are you sure?'"
      default_to { nil }
    end

    option '-p', '--purge' do
      summary "Performs a full uninstall, including configuration files"
      description <<-EOT
      Perform a 'purge', a full uninstall of Puppet Enterprise. Remove all
      configuration files and user home directories in addition to the standard
      uninstall. Puppet Enterprise databases and database users will not be
      removed unless the -d flag is also passed.
      EOT

      default_to { false }
    end

    option '-d', '--database' do
      summary "Also remove any databases during the uninstall."
      default_to { false }
    end

    when_invoked do |options|
      unless options[:yes]
        print 'Uninstall Puppet Enterprise? [N/y] --> '
        input = STDIN.gets.chomp.strip
        if input !~ /^y(es)?$/i
          puts "Aborting..."
          exit 0
        end
      end

      # List of packages to be removed - this is
      # order dependent due to package dependencies.
      packages = [
        'pe-puppetdb',
        'pe-puppet-license-cli',
        'pe-license',
        'pe-puppetdb-termini',
        'pe-console-services-termini',
        'pe-puppetserver',
        'pe-r10k',
        'pe-postgresql-server',
        'pe-postgresql-contrib',
        'pe-postgresql',
        'pe-nginx',
        'pe-console-services',
        'pe-java',
        'pe-puppet-enterprise-release',
        'pe-installer',
        'pe-bundler',
      ]

      symlinks = [
        'facter',
        'hiera',
        'pe-man',
        'puppet',
        'r10k',
      ]


      users_and_groups = [
        'pe-activemq',
        'pe-console-services',
        'pe-orchestration-services',
        'pe-postgres',
        'pe-puppet',
        'pe-puppetdb',
        'pe-webserver',
        'peadmin'
      ]

      packages.each do |pkg|
        pkg_resource = Puppet::Face[:resource, '0.0.1'].find("package/#{pkg}")
        if pkg_resource[:ensure] != :purged
          Puppet.notice "Removing package #{pkg}"
          pkg_resource[:ensure] = :absent
          Puppet::Resource.indirection.save(pkg_resource)
        end
      end

      symlinks.each do |sym|
        link = "/usr/local/bin/#{sym}"
        sym_resource = Puppet::Face[:resource, '0.0.1'].find("file/#{link}")
        if sym_resource[:ensure] == :link
          Puppet.notice "Removing symlink: #{link}"
          sym_resource[:ensure] = :absent
          #Puppet::Resource.indirection.save(sym_resource)
        end
      end

      users_and_groups.each do |usr|
        usr_resource = Puppet::Face[:resource, '0.0.1'].find("user/#{usr}")
        if usr_resource[:ensure] == :present
          Puppet.notice "Removing user #{usr}"
          usr_resource[:ensure] = :absent
          Puppet::Resource.indirection.save(usr_resource)
        end

        group_resource = Puppet::Face[:resource, '0.0.1'].find("group/#{usr}")
        if group_resource[:ensure] == :present
          Puppet.notice "Removing group #{usr}"
          group_resource[:ensure] = :absent
          Puppet::Resource.indirection.save(group_resource)
        end
      end

      if options[:purge]
        directories = [
          '/etc/puppetlabs',
          '/var/log/puppetlabs',
          '/opt/puppetlabs',
        ]

        directories.each do |dir|
          Puppet.notice "Removing directory: #{dir}"
          rsrc = Puppet::Resource.new(:file, dir, :parameters => { :ensure => :absent, :force => true })
          Puppet::Resource.indirection.save(rsrc)
        end
      end

      # As the last step, uninstall puppet-agent
      pkg_resource = Puppet::Face[:resource, '0.0.1'].find("package/puppet-agent")
      Puppet.notice "Removing package: puppet-agent"
      pkg_resource[:ensure] = :absent
      Puppet::Resource.indirection.save(pkg_resource)
    end
  end
end
=end
