require 'puppet_x/util/service_status'

module PuppetX
module Util
  module Links
    DOCS_ROOT = 'https://puppet.com/docs/pe'
    PDB_SYNC_LINK = "#{DOCS_ROOT}/%{version}/configure_high_availability.html#manually-copy-puppetdb-to-speed-replication"
    CONVERT_LEGACY_COMPILER_LINK = "#{DOCS_ROOT}/%{version}/installing_compilers.html#convert-compiler"
  end
  module Docs
    # @param name_symbol [Symbol] Case sensitive symbol or string of the link name
    # @return [String] Link string
    # @raise [NameError] If the given +name_symbol+ is not a
    #   PuppetX::Util::Links constant
    def self.link(name_symbol)
      version = PuppetX::Util::ServiceStatus.pe_version
      PuppetX::Util::Links.const_get(name_symbol) % {version: version}
    end
  end
end
end
