# ReservedCodeCacheSize cannot exceed 2048m, if reserved_code_cache
# is set and greater than 2048, set it to 2048 and warn.
function puppet_enterprise::calculate_reserved_code_cache (
  Optional[Pattern[/^\d+[kmgKMG]$/]] $reserved_code_cache
) {
  if ($reserved_code_cache) {
    # PE-25321
    if ($reserved_code_cache =~ /^(\d+)([kmgKMG])$/) {
      $rcc_integer = Integer($1)
      $rcc_unit  = $2
      $rcc_in_mb = $rcc_unit ? {
        /[kK]/ => Integer($rcc_integer / 1024),
        /[mM]/ => $rcc_integer,
        /[gG]/ => $rcc_integer * 1024,
      }
      if $rcc_in_mb > 2048 {
        warning('limiting $reserved_code_cache to its maximum of 2048 MB')
        $_reserved_code_cache_java_args = {'XX:ReservedCodeCacheSize=' => '2048m'}
      } else {
        $_reserved_code_cache_java_args = {'XX:ReservedCodeCacheSize=' => $reserved_code_cache}
      }
    }
  } else {
    $_reserved_code_cache_java_args = {}
  }
}
