function puppet_enterprise::jfr_java_args (
  String $repository,
  String $filename,
  Optional[String] $settings = 'default',
  Optional[Integer] $stackdepth = 128,
  Optional[String] $maxage = '7d',
  Optional[String] $maxsize = '200m',
) >> Hash {
  $java_args = {
    'XX:FlightRecorderOptions=' => "repository=${repository},stackdepth=${stackdepth}",
    'XX:StartFlightRecording=' => "settings=${settings},disk=true,maxage=${maxage},maxsize=${maxsize},dumponexit=true,filename=${filename}",
  }
}

