define puppet_enterprise::trapperkeeper::activity (
  $container           = $title,
  $database_host       = 'localhost',
  $database_name       = $puppet_enterprise::params::activity_database_name,
  $database_password   = undef,
  $database_port       = $puppet_enterprise::database_port,
  $database_properties = '',
  $database_user       = $puppet_enterprise::activity_service_regular_db_user,
  $database_migration_user = $puppet_enterprise::activity_service_migration_db_user,
  $group               = "pe-${title}",
  $rbac_host           = 'localhost',
  $rbac_port           = $puppet_enterprise::params::console_services_api_listen_port,
  $rbac_url_prefix     = $puppet_enterprise::params::rbac_url_prefix,
  $user                = "pe-${title}",
  $purge_interval      = undef,
  $purge_after         = undef,
  $purge_limit         = undef,
) {
  File {
    owner => $user,
    group => $group,
    mode  => '0640',
  }

  Pe_hocon_setting {
    ensure  => present,
    notify  => Service["pe-${container}"],
  }

  # Uses
  #   $rbac_host
  #   $rbac_port
  #   $rbac_url_prefix
  file { "/etc/puppetlabs/${container}/conf.d/activity.conf":
    ensure => present,
  }
  pe_hocon_setting { 'activity.rbac-base-url':
    path    => "/etc/puppetlabs/${container}/conf.d/activity.conf",
    setting => 'activity.rbac-base-url',
    value   => "http://${rbac_host}:${rbac_port}${rbac_url_prefix}/v1",
  }
  pe_hocon_setting { 'activity.cors-origin-pattern':
    path    => "/etc/puppetlabs/${container}/conf.d/activity.conf",
    setting => 'activity.cors-origin-pattern',
    value   => '.*'
  }
  if $purge_interval {
    $purge_interval_ensure = present
  } else {
    $purge_interval_ensure = absent
  }
  pe_hocon_setting { 'activity.purge-interval':
    ensure  => $purge_interval_ensure,
    path    => "/etc/puppetlabs/${container}/conf.d/activity.conf",
    setting => 'activity.purge-interval',
    value   => $purge_interval
  }

  if $purge_after {
    $purge_after_ensure = present
  } else {
    $purge_after_ensure = absent
  }
  pe_hocon_setting { 'activity.purge-after':
    ensure  => $purge_after_ensure,
    path    => "/etc/puppetlabs/${container}/conf.d/activity.conf",
    setting => 'activity.purge-after',
    value   => $purge_after
  }

  if $purge_limit {
    $purge_limit_ensure = present
  } else {
    $purge_limit_ensure = absent
  }
  pe_hocon_setting { 'activity.purge-limit':
    ensure  => $purge_limit_ensure,
    path    => "/etc/puppetlabs/${container}/conf.d/activity.conf",
    setting => 'activity.purge-limit',
    value   => $purge_limit
  }

  puppet_enterprise::trapperkeeper::database_settings { 'activity' :
    container           => $container,
    database_host       => $database_host,
    database_name       => $database_name,
    database_password   => $database_password,
    database_port       => Integer($database_port),
    database_properties => $database_properties,
    database_user       => $database_user,
    migration_user      => $database_migration_user,
    migration_password  => $database_password,
    group               => $group,
    user                => $user,
  }

  puppet_enterprise::trapperkeeper::bootstrap_cfg { "${container}:activity activity-service" :
    container => $container,
    namespace => 'puppetlabs.activity.services',
    service   => 'activity-service',
  }

  puppet_enterprise::trapperkeeper::bootstrap_cfg { "${container}:activity jetty10-service" :
    container => $container,
    namespace => 'puppetlabs.trapperkeeper.services.webserver.jetty10-service',
    service   => 'jetty10-service',
  }
}
