require 'pe_backup_tools/utils'

module PeBackupTools
  module Utils
    # This module provides methods for querying information from PuppetDB
    module PuppetDB
      class PuppetDBQueryError < RuntimeError; end

      def self.capitalize_class(class_name)
        class_name.split('::').map(&:capitalize).join('::')
      end

      def self.get_nodes_with_class(class_name, puppetdb_host, cert_conf, port = 8081)
        pdb_url = "https://#{puppetdb_host}:#{port}/pdb/query/v4/resources"
        request_body = '{"query": ["extract", "certname", ["and", ["=", "type", "Class"], ["=", "title", "' + capitalize_class(class_name) + '"]]]}'
        response = PeBackupTools::Utils.post_response(pdb_url, cert_conf, request_body, raise_on_failure: false)
        if response.code != '200'
          raise PuppetDBQueryError, "Received #{response.code} response from PuppetDB: #{response.body}"
        end
        begin
          JSON.parse(response.body).map { |x| x['certname'] }.uniq
        rescue JSON::ParserError
          raise PuppetDBQueryError, "Recieved unexpected response from PuppetDB: #{response.body}"
        end
      end

      def self.get_class_for_certname(class_name, certname, puppetdb_host, cert_conf, port = 8081)
        pdb_url = "https://#{puppetdb_host}:#{port}/pdb/query/v4/resources"
        request_body = '{"query": ["and", ["=", "certname", "' + certname + '"], ["=", "type", "Class"], ["=", "title", "' + capitalize_class(class_name) + '"]]}'
        response = PeBackupTools::Utils.post_response(pdb_url, cert_conf, request_body, raise_on_failure: false)
        if response.code != '200'
          raise PuppetDBQueryError, "Received #{response.code} response from PuppetDB: #{response.body}"
        end
        begin
          JSON.parse(response.body).first
        rescue JSON::ParserError
          raise PuppetDBQueryError, "Recieved unexpected response from PuppetDB: #{response.body}"
        end
      end
    end
  end
end
