require 'cgi'
require 'json'
require 'date'

require 'pe_license'

class PELicense::Status
  def self.retrieve(client, uri)
    begin
      today = Date.today.to_s
      uri.path = '/v1/usage'
      uri.query = "start_date=#{today}&end_date=#{today}"
      response = client.get(uri)
      code = response.code.to_i
      raise response.body unless (200...300).include?(code)

      result = JSON.parse(response.body)

      if result['items'].empty?
        nodes = 0
      else
        nodes = result['items'].first['total_nodes']
      end

      new(nodes)

    rescue => e
      raise "Unable to retrieve license from the license server: #{e}"
    end
  end

  attr_reader :nodes

  def initialize(nodes)
    @nodes = nodes
  end
end
