# frozen_string_literal: true

##############################################################
## DO NOT EDIT THIS FILE                                    ##
## Use /etc/puppetlabs/bolt-server/conf.d/bolt-server.conf  ##
## to configure the sinatra server                          ##
##############################################################

require 'pe_bolt_server/transport_app'
require 'pe_bolt_server/acl'
require 'pe_bolt_server/config'
require 'bolt/logger'

Bolt::Logger.initialize_logging

config_path = ENV['BOLT_SERVER_CONF'] || '/etc/puppetlabs/bolt-server/conf.d/bolt-server.conf'

config = PEBoltServer::Config.new
config.load_file_config(config_path)
config.load_env_config
config.validate

Bolt::Logger.logger(:root).add_appenders Logging.appenders.stderr(
  'console',
  layout: Bolt::Logger.default_layout,
  level: config['loglevel']
)

if config['logfile']
  stdout_redirect config['logfile'], config['logfile'], true
end

config.load_logger
config.load_ssl_data
config.load_entitlements

after_stopped do
  config['entitlements'].stop_entitlements_check
end

# TODO: use ssl_bind
# rubocop:disable Style/RedundantInterpolationUnfreeze
bind_addr = +"ssl://#{config['host']}:#{config['port']}?"
# rubocop:enable Style/RedundantInterpolationUnfreeze
bind_addr << "cert=#{config['ssl-cert']}"
bind_addr << "&key=#{config['ssl-key']}"
bind_addr << "&ca=#{config['ssl-ca-cert']}"
bind_addr << "&verify_mode=force_peer"
bind_addr << "&ssl_cipher_filter=#{config['ssl-cipher-suites'].join(':')}"
bind bind_addr

threads 0, config['concurrency']

impl = PEBoltServer::TransportApp.new(config)

if config['allowlist']
  impl = PEBoltServer::ACL.new(impl, config['allowlist'])
end

app impl
