# frozen_string_literal: true
require 'pathname'
# THIS IS A PE SPECIFIC IMPLEMENTATION OF FILE::READ: THIS IMPLEMENTATION WILL OVERRIDE THE ONE
# THAT COMES WITH A BOLT INSTALLATION
#
# Open-source bolt implementation:
# https://github.com/puppetlabs/bolt/blob/master/bolt-modules/file/lib/puppet/functions/file/read.rb
#
Puppet::Functions.create_function(:'file::read', Puppet::Functions::InternalFunction) do
  dispatch :read do
    scope_param
    required_param 'String', :filename
    return_type 'String'
  end

  def validate_path(path)
    raise(Puppet::Error, "Absolute paths aren't supported for file::read: #{path}") if Pathname.new(path).absolute?
    raise(Puppet::Error, "Parent directory access isn't supported for file::read: #{path}") if path.split('/').include?('..')
  end

  def read(scope, filename)
    validate_path(filename)
    found = Bolt::Util.find_file_from_scope(filename, scope)
    unless found && Puppet::FileSystem.exist?(found)
      raise Puppet::ParseErrorWithIssue.from_issue_and_stack(
        Puppet::Pops::Issues::NO_SUCH_FILE_OR_DIRECTORY, file: filename
      )
    end

    File.read(found)
  end
end
