# frozen_string_literal: true

# THIS IS A PE SPECIFIC IMPLEMENTATION OF resolve_references: THIS IMPLEMENTATION WILL OVERRIDE THE ONE
# THAT COMES WITH A BOLT INSTALLATION
#
# Open-source bolt implementation:
# https://github.com/puppetlabs/bolt/blob/master/bolt-modules/boltlib/lib/puppet/functions/resolve_references.rb
#
# resolve_references for plans-in-PE will return an error since it is not needed in the current iteration
# of plans in PE.
Puppet::Functions.create_function(:resolve_references) do
  # Resolve references.
  # @param references A hash of reference data to resolve.
  # @return A hash of resolved reference data.
  # @example Resolve a hash of reference data
  #   $references = {
  #     "targets" => [
  #       "_plugin" => "terraform",
  #       "dir" => "path/to/terraform/project",
  #       "resource_type" => "aws_instance.web",
  #       "uri" => "public_ip"
  #     ]
  #   }
  #
  #   resolve_references($references)
  dispatch :resolve_references do
    param 'Data', :references
    return_type 'Data'
  end

  def resolve_references(references)
    unless Puppet[:tasks]
      raise Puppet::ParseErrorWithIssue
        .from_issue_and_stack(
          Bolt::PAL::Issues::PLAN_OPERATION_NOT_SUPPORTED_WHEN_COMPILING,
          action: 'resolve_references'
        )
    end
    raise Puppet::Error, "resolve_references is currently not supported in PE plans"
  end
end
