#!/opt/puppetlabs/puppet/bin/ruby
# frozen_string_literal: true

require_relative '../files/enterprise_task_helper.rb'
require 'open3'

class ReinitializeReplica < EnterpriseTaskHelper
  def task(database: nil, **_kwargs)
    puppet_infra = '/opt/puppetlabs/bin/puppet-infra'
    command = [puppet_infra, 'reinitialize', 'replica', '-y']
    command += ['--db', database] if !database.nil?
    output, status = Open3.capture2e(*command)

    if !status.success?
      raise EnterpriseTaskHelper::Error.new(
        'Failed puppet-infra reinitialize replica.',
        'puppetlabs.reinitialize-replica/failed-reinitialize',
        {
          database: database,
          output:   output,
          status:   status.exitstatus,
        },
      )
    end

    {
      output: output,
      success: true,
    }.to_json
  end
end

ReinitializeReplica.run if __FILE__ == $PROGRAM_NAME
