define puppet_enterprise::certs::whitelist_entry(
  $target,
  $certname = $title
) {
  notify { "${title} using deprecated define":
    message  => "The puppet_enterprise::certs::whitelist_entry define is deprecated and will be removed in a future release. Please use puppet_enterprise::certs::allowlist_entry instead.",
    loglevel => 'warning',
  }
  puppet_enterprise::certs::allowlist_entry { $title:
    target   => $target,
    certname => $certname,
  }
}

