require 'puppet/indirector/face'
require 'puppet_x/puppetlabs/tune'
require 'puppet_x/util/stringformatter'

Puppet::Face.define(:infrastructure, '1.0.0') do
  action(:tune) do
    summary _('Inspect infrastructure and output optimized settings.')
    description(
      PuppetX::Util::String::Formatter.join_and_wrap_no_indent([
      _('Collects information about your Puppet Enterprise installation.'),
      _('Outputs current or optimized settings that tune Puppet Enterprise services.')]))

    option '--common' do
      summary _('Extract common settings from node-specific settings')
      default_to { false }
    end

    option '--compare' do
      summary _('Output comparison of currently-defined and optimized settings, and exit')
      default_to { false }
    end

    option '--current' do
      summary _('Output currently-defined settings, and exit')
      default_to { false }
    end

    option '--estimate' do
      summary _('Output an estimated capacity summary')
      default_to { false }
    end

    option '--force' do
      summary _('Do not enforce minimum system requirements')
      default_to { false }
    end

    option '--hiera DIRECTORY' do
      summary _('Output Hiera YAML files to a directory')
      default_to { nil }
    end

    option '--inventory FILE' do
      summary _('Use a YAML file to define nodes')
      default_to { nil }
    end

    option '--local' do
      summary _('Use the local system to define a node')
      default_to { false }
    end

    option '--memory_per_jruby MB' do
      summary _('Amount of RAM to allocate for each JRuby')
      default_to { nil }
    end

    option '--memory_reserved_for_os MB' do
      summary _('Amount of RAM to reserve for the OS')
      default_to { nil }
    end

    option '--node CERTNAME' do
      summary _('The node to tune')
      default_to { nil }
    end

    option '--pe_conf' do
      summary _('Output HOCON to pe.conf')
      default_to { false }
    end

    option '--use_current_memory_per_jruby' do
      summary _('Use currently-defined settings to determine memory_per_jruby')
      default_to { false }
    end

    when_invoked do |*args|
      options = args.pop
      Puppet.debug("Command Options: #{options}")
      tune = PuppetX::Puppetlabs::Tune.new(options)

      tune.collect_infrastructure_nodes
      tune.output_infrastructure

      if options[:compare]
        tune.output_compare_current_and_optimized_settings
      elsif options[:current]
        tune.output_current_settings
      else
        tune.output_optimized_settings
      end

      return
    end
  end
end
