# For the integration of pe_status_check module features into the console
class puppet_enterprise::profile::console::status_check (
  String $description_path = $puppet_enterprise::status_check_description_path,
){
  $data_parameter = 'pe_status_check::checks'
  # If either we can't find the value, or the value is not a hash, use an empty hash
  $status_check_data = assert_type(Hash, lookup($data_parameter, {'default_value' => {}})) |$expected, $actual| { {} }

  file { $description_path:
    ensure  => file,
    group  => 'pe-console-services',
    owner  => 'pe-console-services',
    mode   => '0640',
    content => puppet_enterprise::to_json_pretty($status_check_data),
    require => Package['pe-console-services'],
    notify  => Service['pe-console-services'],
  }
}
