function puppet_enterprise::calculate_puppetserver_jruby_max_active_instances (
) >> Optional[Integer] {
  include puppet_enterprise::params
  $percent_cpu_puppetserver = 0.75
  $minimum_cpu_puppetserver = 1
  $maximum_cpu_puppetserver = 24

  if $trusted['extensions']['pp_auth_role'] == 'pe_compiler' {
    $puppetserver_jruby_max_active_instances_by_cpu = pe_clamp(
      $minimum_cpu_puppetserver,
      (Integer($puppet_enterprise::params::cpu * $percent_cpu_puppetserver)),
      $maximum_cpu_puppetserver)

    $available_ram_puppetserver = ($puppet_enterprise::params::memorysize_in_mb - $puppet_enterprise::params::reserved_memory_for_os_in_mb - $puppet_enterprise::params::puppetdb_heap_size)
    $puppetserver_jruby_max_active_instances_by_ram = pe_max(
      Integer($available_ram_puppetserver / puppet_enterprise::puppetserver_ram_per_jruby()),
      $minimum_cpu_puppetserver)
    $puppetserver_jruby_max_active_instances = pe_min(
      $puppetserver_jruby_max_active_instances_by_cpu,
      $puppetserver_jruby_max_active_instances_by_ram)
  } else {
    $puppetserver_jruby_max_active_instances = undef
  }
}
