module Puppet::Util::Gcp
  class Status
    attr_reader :failures

    REQUIRED_MAJOR_VER = 14
    MIN_MINOR_VERSION = 0

    def initialize(status_hash)
      @status_hash = status_hash
      @failures = []

      validate_status_hash
    end

    def validate_status_hash
      validate_postgres_version
    end

    def validate_postgres_version
      # This should be a string like POSTGRES_14_17
      db, major, minor = @status_hash.fetch('databaseInstalledVersion', '').split('_')
      major = major.to_i
      minor = minor.to_i

      @failures << "instance type #{db} must be a Postgres database" unless db.downcase.start_with?('postgres')
      @failures << "expected Postgres major version #{REQUIRED_MAJOR_VER} found #{major}" if major != REQUIRED_MAJOR_VER
      @failures << "requires Postgres #{REQUIRED_MAJOR_VER} with minor version greater than #{MIN_MINOR_VERSION} found #{minor}" if minor < MIN_MINOR_VERSION
    end

    def valid?
      failures.empty?
    end
  end
end
