require "puppet_x/util/stringformatter"

module PuppetX
  module Util
    class InfrastructureError < StandardError
    end

    class InfrastructureUnknownRoleError < InfrastructureError
      attr_reader :role, :known_roles

      def initialize(role, known_roles)
        error = PuppetX::Util::String::Formatter.join_and_indent([
          _("Unknown role %{role}") % { role: role },
          _("Known roles:"), ""], PuppetX::Util::String::Formatter.indent_level(2))
        known_roles_string = PuppetX::Util::String::Formatter.join_and_indent(known_roles, PuppetX::Util::String::Formatter.indent_level(3))
        super(error + known_roles_string)
        @role = role
      end
    end

    class InfrastructureUnknownTopologyError < InfrastructureError
      attr_reader :topology, :known_topologies

      def initialize(topology, known_topologies)
        error = PuppetX::Util::String::Formatter.join_and_indent([
          _("Unknown role %{topology}") % { topology: topology },
          _("Known roles:"), "\n"], PuppetX::Util::String::Formatter.indent_level(2))
        known_topology_string = PuppetX::Util::String::Formatter.join_and_indent(known_topologies, PuppetX::Util::String::Formatter.indent_level(3))
        super(error + known_topology_string)
        @topology = topology
        @known_topologies = known_topologies
      end
    end
  end
end
