require 'hocon'

module PuppetX
  module Util
    class RBAC

      def self.default_token_path()
        File.expand_path('~/.puppetlabs/token')
      end

      def self.load_token(path_override=nil)
        path = path_override || self.default_token_path()
        unless File.file?(path)
          raise _("Couldn't find an RBAC token at %{path}.") % { path: path } + " " + _("Run 'puppet access login --lifetime 8h' to get a token with an 8 hour lifetime.")
        end
        File.read(path).strip
      end

    end
  end
end
