class pe_manager::promote (
  $classifier_database_write_user      = $puppet_enterprise::classifier_database_write_user,
  $rbac_database_write_user            = $puppet_enterprise::rbac_database_write_user,
  $activity_database_write_user        = $puppet_enterprise::activity_database_write_user,
  $classifier_database_name            = $puppet_enterprise::classifier_database_name,
  $rbac_database_name                  = $puppet_enterprise::rbac_database_name,
  $activity_database_name              = $puppet_enterprise::activity_database_name,
  $orchestrator_database_name          = $puppet_enterprise::orchestrator_database_name,
  $inventory_database_name             = $puppet_enterprise::inventory_database_name,
  $host_action_collector_database_name = $puppet_enterprise::host_action_collector_database_name,
  $patching_database_name              = $puppet_enterprise::patching_database_name,
  $infra_assistant_database_name       = $puppet_enterprise::infra_assistant_database_name,
  $workflow_database_name              = $puppet_enterprise::workflow_database_name,
) inherits puppet_enterprise {

  # We don't currently necessarily need to set all of these globals
  # settings, but we've run into enough bugs due to missing settings
  # over the years that it's easier to just to lift this from
  # puppet_enterprise::profile::database and ensure
  # the pe_postgresql module has everything it needs.
  $pgsqldir = "${puppet_enterprise::server_data_dir}/postgresql"
  $version = $puppet_enterprise::params::postgres_version
  $datadir = "${pgsqldir}/${version}/data"

  class { '::pe_postgresql::globals':
    user                 => $puppet_enterprise::pg_user,
    group                => $puppet_enterprise::pg_group,
    client_package_name  => $puppet_enterprise::params::postgresql_client_package_name,
    server_package_name  => $puppet_enterprise::params::postgresql_server_package_name,
    contrib_package_name => $puppet_enterprise::params::postgresql_contrib_package_name,
    service_name         => 'pe-postgresql',
    default_database     => $puppet_enterprise::params::postgresql_default_database,
    version              => $version,
    bindir               => $puppet_enterprise::server_bin_dir,
    datadir              => $datadir,
    confdir              => $datadir,
    psql_path            => $puppet_enterprise::pg_psql_path,
  }

  include pe_postgresql::params


  $subscription_name = sprintf('s%.14s', sha1($trusted['certname']))

  [
    $classifier_database_name,
    $rbac_database_name,
    $activity_database_name,
    $orchestrator_database_name,
    $inventory_database_name,
    $host_action_collector_database_name,
    $patching_database_name,
    $infra_assistant_database_name,
    $workflow_database_name,
  ].map |$database_name| {
    # Remove pglogical subscriptions from when this node was a replica
    puppet_enterprise::pg::pglogical::subscription { "${database_name}/${subscription_name}":
      ensure            => absent,
      subscription_name => $subscription_name,
      database          => $database_name,
      notify            => Service['pe-console-services']
    }
  }

  $container = 'console-services'
  pe_hocon_setting { "${container}.classifier.database.user":
    path    => "/etc/puppetlabs/${container}/conf.d/classifier-database.conf",
    setting => 'classifier.database.user',
    value   => $classifier_database_write_user,
  }

  pe_hocon_setting { "${container}.activity.database.user":
    path    => "/etc/puppetlabs/${container}/conf.d/activity-database.conf",
    setting => 'activity.database.user',
    value   => $activity_database_write_user,
  }

  pe_hocon_setting { "${container}.rbac.database.user":
    path    => "/etc/puppetlabs/${container}/conf.d/rbac-database.conf",
    setting => 'rbac.database.user',
    value   => $rbac_database_write_user,
  }

  pe_hocon_setting{ "${container}.global.replication-mode":
    path    => "/etc/puppetlabs/${container}/conf.d/global.conf",
    setting => 'global.replication-mode',
    value   => 'source',
  }

  service { 'pe-console-services':
    ensure    => running,
    subscribe => [
      Pe_hocon_setting["${container}.global.replication-mode"],
      Pe_hocon_setting["${container}.classifier.database.user"],
      Pe_hocon_setting["${container}.rbac.database.user"],
      Pe_hocon_setting["${container}.activity.database.user"],
    ]
  }
}
