#pragma once

#include <set>
#include <string>
#include <boost/nowide/cenv.hpp>
#include "export.h"

#include <leatherman/json_container/json_container.hpp>

namespace puppet_access { namespace config {

namespace json = leatherman::json_container;

std::string native_path(std::string path_str);

struct LIBPUPPET_ACCESS_EXPORT config {
    std::string token_file;
    std::string certificate_file;
    std::string service_url;

    config() {}

    config(const std::string& token_file,
           const std::string& certificate_file)
        : token_file(token_file), certificate_file(certificate_file) {}

    config(const std::string& token_file,
           const std::string& certificate_file,
           const std::string& service_url)
        : token_file(token_file), certificate_file(certificate_file), service_url(service_url) {}

    config & operator=(const config &);
    bool empty() const;
    std::string pretty_print() const;
    config & merge(const config &other);
};

extern const config LIBPUPPET_ACCESS_EXPORT default_config;

std::string LIBPUPPET_ACCESS_EXPORT get_puppetlabs_root();
std::string LIBPUPPET_ACCESS_EXPORT get_default_token_file();
std::string LIBPUPPET_ACCESS_EXPORT get_default_config_file();
std::string LIBPUPPET_ACCESS_EXPORT get_deprecated_default_config_file();
std::string LIBPUPPET_ACCESS_EXPORT get_global_config_file();
std::string LIBPUPPET_ACCESS_EXPORT get_default_certificate_file();
std::set<std::string> LIBPUPPET_ACCESS_EXPORT invalid_config_keys(const json::JsonContainer& object);
bool LIBPUPPET_ACCESS_EXPORT is_valid_as_config(const json::JsonContainer& object);
config LIBPUPPET_ACCESS_EXPORT parse_config(const std::string& json_body);
config LIBPUPPET_ACCESS_EXPORT config_from_json(const json::JsonContainer& object);
config LIBPUPPET_ACCESS_EXPORT config_from_file(const std::string& path);

}  // namespace request
}  // namespace puppet_access
