#!/opt/puppetlabs/puppet/bin/ruby
# frozen_string_literal: true

require_relative '../files/enterprise_task_helper.rb'
require_relative '../lib/enterprise_tasks/network'
require_relative '../lib/enterprise_tasks/rbac'

class DeleteEnterpriseTasksRBACUser < EnterpriseTaskHelper
  include EnterpriseTasks::Network
  include EnterpriseTasks::RBAC

  def task(**_kwargs)
    delete_enterprise_tasks_user_and_role
    { success: true }.to_json
  end
end

DeleteEnterpriseTasksRBACUser.run if __FILE__ == $PROGRAM_NAME
