# frozen_string_literal: true

# Stolen from https://github.com/puppetlabs/bolt/blob/3.27.4/lib/logging_extensions/logging.rb
module LoggingExtensions
  # the logging gem always sets itself up to initialize little-plugger
  # https://github.com/TwP/logging/commit/5aeeffaaa9fe483c2258a23d3b9e92adfafb3b2e
  # little-plugger calls Gem.find_files, incurring an expensive gem scan
  def initialize_plugins; end
end

require 'logging'
# monkey patch Logging to override the extended method with a no-op
Logging.extend(LoggingExtensions)

module PlanRunner
  module LoggingHelper
    LOGGING_LEVELS = %w[trace debug info warn error fatal].freeze

    def self.logging_layout
      Logging.layouts.pattern(
        pattern: '%d %-6l [%p] [%c] %m\n',
        date_pattern: '%Y-%m-%dT%H:%M:%S.%6N'
      )
    end

    def self.reinit_root_logger(log_file, log_level)
      Logging.logger.root.clear_appenders
      Logging.logger.root.add_appenders Logging.appenders.file(
        'log_file',
        filename: log_file,
        layout: LoggingHelper.logging_layout,
        level: log_level
      )
    end
  end
end
