# Assumes the passed variable is either a Puppet certname or 'localhost'
# If localhost, uses puppet config to obtain the certname from localhost
# puppet.conf.
function enterprise_tasks::get_certname(
  String $node,
) {
  case $node {
    'localhost': {
      $certname = run_command('puppet config print certname --section agent', $node).first['stdout'].strip
    }
    default: { $certname = $node }
  }
  return $certname
}
