# frozen_string_literal: true

require 'puppet'

# Module for looking up hiera values from tasks
# rubocop:disable Style/ClassAndModuleChildren
module EnterpriseTasks
  module Hiera

    def self.enterprise_module_path
      '/opt/puppetlabs/server/data/environments/enterprise/modules'
    end

    def set_lib_path
      lib_path = "#{EnterpriseTasks::Hiera.enterprise_module_path}/pe_infrastructure/lib"
      if !Dir.exist?(lib_path)
        raise(EnterpriseTaskHelper::Error.new("Unable to find pe_infrastructure module at #{lib_path}", 'ERROR:hiera/pe_infrastrcuture module not found'))
      end
      $LOAD_PATH << lib_path unless $LOAD_PATH.include?(lib_path)
    end

    def initialize_hiera_settings
      Puppet.initialize_settings(['--libdir=/dev/null', '--factpath=/dev/null'])
      set_lib_path
      require 'puppet_x/puppetlabs/meep/hiera_adapter.rb'
    end

    def enterprise_hiera_yaml
      '/etc/puppetlabs/enterprise/hiera.yaml'
    end

    def enterprise_lookup_handle
      PuppetX::Puppetlabs::Meep::HieraAdapter.new(enterprise_hiera_yaml)
    end

    def hiera_lookup(hiera_param)
      enterprise_lookup_handle = PuppetX::Puppetlabs::Meep::HieraAdapter.new(enterprise_hiera_yaml)
      node = PuppetX::Puppetlabs::Meep::HieraAdapter.get_node
      scope = PuppetX::Puppetlabs::Meep::HieraAdapter.generate_scope(node)
      enterprise_lookup_handle.lookup(hiera_param, scope)
    end

  end
end
