#!/opt/puppetlabs/puppet/bin/ruby
# frozen_string_literal: true

require_relative '../files/enterprise_task_helper.rb'
require 'open3'

class WaitForEnvDeploy < EnterpriseTaskHelper
  def task(enable_lockless:, tries: 40, wait_interval: 30, **_kwargs)
    ls_cmd = enable_lockless ? '/etc/puppetlabs/puppetserver/code | fgrep puppet-code' : '/etc/puppetlabs/code/environments'
    tries.times do
      _, status = Open3.capture2e("ls -l #{ls_cmd}")
      return '{}' if status.exitstatus == 0
      sleep(wait_interval)
    end
    raise(EnterpriseTaskHelper::Error.new('Code deploy failed', 'ERROR:codemanager code deploy failed'))
  end
end

WaitForEnvDeploy.run if __FILE__ == $PROGRAM_NAME
