# Function to test if a given class was included in the latest catalog for a node
# @param classname The classname to check.  In PDB each segment is capitalized, i.e. Puppet_enterprise::Class_included
# @param vendored Whether to test if the class were included from a "vendored" module. Comparison is made using the `tag` attribute,
#   which will include "puppet_enterprise" if it came from PE code.  A custom tag may be used if explicitly set in a class{} declaration.
function puppet_enterprise::class_previously_included(
  String  $classname,
  Optional[String[1]] $vendor_tag = undef,
) >> Boolean {
  if $vendor_tag {
    $query = @("PQL"/L)
resources[certname] {
  certname = "${trusted['certname']}" and
  type = "Class" and
  title = "${classname}" and
  tag = "${vendor_tag}" and
  nodes {
    deactivated is null and
    expired is null
  }
}
| PQL
  }
  else {
    $query = @("PQL"/L)
resources[certname] {
  certname = "${trusted['certname']}" and
  type = "Class" and
  title = "${classname}" and
  nodes {
    deactivated is null and
    expired is null
  }
}
| PQL
  }

  $results = puppetdb_query($query).map |$data| { $data['certname'] }
  !empty($results)
}
