module PuppetX
module Puppetlabs
module Meep
module Infra

  # Default values needed by Infrastructure actions and their support modules.
  # Curently only used by the Configure action.
  #
  # The individual defaults are Constants in this module for the purpose of
  # API documentation.
  module Constants
    # This is the major version of the Postgresql in this branch of PE.
    # A migration is required whenever this version changes (not the patch
    # version)
    CURRENT_POSTGRES_VERSION = '14'

    # Postgresql certification for FIPS platforms lags behind and needs
    # to be tracked separately.
    CURRENT_FIPS_POSTGRES_VERSION = '14'

    # This is the sequence of Postgresql versions PE has migrated through
    # over the years. This allows us to determine which version we should
    # be coming from based on our current version. Useful when testing
    # new versions before actually bumping the CURRENT versions above.
    # The oldest version here should be the version prior to the version
    # used in the current LTS.
    POSTGRES_VERSION_SEQUENCE = ['9.6', '11', '14']

    # This file is used to mark the version we are upgrading from if the
    # --upgrade-from flag has been passed in.  It persists until we have a
    # successful run of the configure face.
    UPGRADE_IN_PROCESS_FILE = '/opt/puppetlabs/server/upgrade_in_process'

    # Location of MEEP's pe.conf hieradata directory.
    ENTERPRISE_CONF_DIR = '/etc/puppetlabs/enterprise'
  end

  # Any module needing these constants must include Defaults, and look them up
  # with the neutral Defaults#infra_default(name) accessor method, unless
  # referencing them by their full
  # PuppetX::Puppetlabs::Meep::Infra::Constants::CONSTANT namespace...
  module Defaults

    # @param name [Symbol,String] Case sensitive symbol or string of the
    #   constant to return a value for.
    # @return [String] Value of the constant.
    # @raise [NameError] If the given +name+ is not a
    #   PuppetX::Puppetlabs::Meep::Infra::Constants constant.
    def infra_default(name_symbol)
      PuppetX::Puppetlabs::Meep::Infra::Constants.const_get(name_symbol)
    end
  end
end
end
end
end
